/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.recipes.crushing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.tiviacz.pizzacraft.blockentity.content.BasinContent;
import com.tiviacz.pizzacraft.recipes.crushing.CrushingRecipe;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class CrushingRecipeSerializer
implements RecipeSerializer<CrushingRecipe> {
    public static final CrushingRecipeSerializer INSTANCE = new CrushingRecipeSerializer();
    public static final ResourceLocation ID = new ResourceLocation("pizzacraft", "crushing_recipe");

    public CrushingRecipe fromJson(ResourceLocation id, JsonObject json) {
        Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        if (input.m_43947_()) {
            throw new JsonParseException("Missing Input in Crushing Recipe!");
        }
        int inputCount = GsonHelper.m_13927_((JsonObject)json, (String)"inputCount");
        String basinContent = GsonHelper.m_13906_((JsonObject)json, (String)"content");
        ItemStack outputStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        return new CrushingRecipe(input, inputCount, basinContent, outputStack, id);
    }

    public CrushingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int inputCount = buf.readInt();
        String basinContent = buf.m_130277_();
        ItemStack outputStack = buf.m_130267_();
        return new CrushingRecipe(input, inputCount, basinContent, outputStack, id);
    }

    public void toNetwork(FriendlyByteBuf buf, CrushingRecipe recipe) {
        recipe.getInput().m_43923_(buf);
        buf.writeInt(recipe.getInputCount());
        buf.m_130070_(recipe.getContentOutput().toString());
        buf.m_130055_(recipe.m_8043_());
    }

    public static BasinContent deserializeContent(@Nullable String content) {
        if (content != null) {
            if (BasinContent.BasinContentRegistry.REGISTRY.fromString(content) != null) {
                return BasinContent.BasinContentRegistry.REGISTRY.fromString(content);
            }
            throw new JsonSyntaxException("Content does not exist!");
        }
        throw new JsonSyntaxException("Content cannot be null");
    }

    public static BasinContent deserializeContent(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            String content = json.getAsString();
            if (BasinContent.BasinContentRegistry.REGISTRY.fromString(content) != null) {
                return BasinContent.BasinContentRegistry.REGISTRY.fromString(content);
            }
            throw new JsonSyntaxException("Content does not exist!");
        }
        throw new JsonSyntaxException("Content cannot be null");
    }
}

